--------------------------------------------------------------------------------------------------
-- File lua for Markindel DC3
--------------------------------------------------------------------------------------------------

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/DC3.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/DC3_NewTextures.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/")
--mount_vfs_sound_path (current_mod_path.."/Sounds")



DC3 = 
{
	Name 				=   'DC3',
	DisplayName			= _('DC3'),
--	HumanCockpit 		= false,
	Picture 				= current_mod_path..'/Textures/DC3.png',
	Rate 				= 40, -- RewardPoint in Multiplayer
--	singleInFlight = true,
	Shape 				= "DC3",
	shape_table_data 	= 
	{
		{
			file  	 = 'DC3';
			life  	 = 60; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'DC3_destr'; -- Name of destroyed object file name
			fire  	 = { 500, 4}; -- Fire on the ground after destoyed: 500sec 4m
			username = 'DC3';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "DC3_destr";
			file  = "DC3-destr";
			fire  = { 500, 4};
		},

	},
	mapclasskey = "P0091000029",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Cruiser, WSTYPE_PLACEHOLDER , "Transports",},
	Categories 			= {},

	-------------------------
	--InternalCargo = {nominalCapacity = 1604, maximalCapacity = 2224},
	M_empty 					= 7650+1604, -- kg + Note 1604 kg represents about 22 passengers based on 1940's av weight and gives 100% load with full fuel
	M_nominal 					= 10705, -- kg
	M_max 						= 11430, -- kg
	M_fuel_max 					= 2176, -- kg
	length 						= 19.65, -- full length in m
	height 						= 5.17, -- height in m
	wing_area 					= 91.7, -- wing area in m2
	wing_span 					= 28.96, -- wing spain in m
	wing_type 					= 0,
	wing_tip_pos 				=  {-4.5,	0.5, 14.5}, -- wingtip coords for visual effects
	

--------------------------------------------------------------------------------
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra	

--	nose_gear_pos				= 	{-10.522,	-1.125,	0}, -- nosegear coord 3.769,	-2.353,	0  ----- Ruotino posteriore
--	main_gear_pos 				= 	{0.635,	       -2.350,	2.534}, -- main gear coords 0.072,	-2.374,	2.341	--- carrello principale
	nose_gear_pos				= 	{-11.888,	-1.022,	0}, -- nosegear coord 3.769,	-2.353,	0  ----- Ruotino posteriore
	main_gear_pos 				= 	{0.018,	       -3.249,	2.534}, -- main gear coords 0.072,	-2.374,	2.341	--- carrello principale
	
	tand_gear_max 				= 0.05,  -------- angolo di rotazione del ruotino posteriore
	nose_gear_wheel_diameter 	= 0.893, -- in m
	main_gear_wheel_diameter 	= 1.395, -- in m
	stores_number				=	0,
	V_opt 						= 73,-- Cruise speed (for AI)
	V_take_off 					= 41, -- Take off speed in m/s (for AI)  
	V_land 						= 49, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 96, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 102, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 5.7, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.3, -- Max speed in Mach (for AI)
	H_max 					 	= 7071, -- m
	Ny_min 						= -1, -- Min G (for AI)
	Ny_max 						= 2.5,  -- Max G (for AI)
	Ny_max_e 					= 1.5,  -- Max G (for AI)
	AOA_take_off 				= 0.14, -- AoA in take off (for AI)
	bank_angle_max 				= 45, -- Max bank angle (for AI)
	average_fuel_consumption 	= 0.075, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	range 						= 1650, -- Max range in km (for AI)
	crew_size	                = 5, 
	CAS_min 					= 33, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	thrust_sum_max 				= 12000,
	thrust_sum_ab 				= 12000,
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	flaps_maneuver 				= 0.26, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	RCS 						= 5, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.2, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	engines_count				= 2, -- Engines count

------------------------------------------------------------------------------	
-- Fumo scarico motori {x,y,z}
------------------------------------------------------------------------------
	engines_nozzles = 
	{
		[1] = 
		{
				pos = 	{0,	-1.45,	-3.4},
				elevation	=	0,
				diameter	=	0.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.46,
				smokiness_level     = 	0.05,
				engine_number  = 1, --both to first engine
		},
		[2] = 
		{
			pos = 	{0,	-1.45,	3.4},
				elevation	=	0,
				diameter	=	0.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.46,
				smokiness_level     = 	0.05,
				engine_number  = 2, --both to 2nd engine
		},
	}, -- end of engines_nozzles
--------------------------------------------------------------------------------
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra


---------------------------------------------------------------------------------
--  equipaggio
---------------------------------------------------------------------------------

	crew_size	 = 5,
	crew_members = 
	{
			[1] = 
			{	pilot_name          = "pilot_raf", --pilot
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-7.4,	-0.3,	-1.6},
				drop_parachute_name	 =  "pilot_raf_parachute",
			}, -- end of [1]
			[2] = 
			{	pilot_name          = "pilot_raf", --copilot
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-7.4,	-0.3,	-1.6},
				drop_parachute_name	 =  "pilot_raf_parachute",
			}, -- end of [2]
			[3] = 
			{	pilot_name          = "pilot_raf", --radio op
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-7.4,	-0.3,	-1.6},
				drop_parachute_name	 =  "pilot_raf_parachute",
			}, -- end of [3]
			[4] =
			{	pilot_name          = "pilot_raf", --nav
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-7.4,	-0.3,	-1.6},
				drop_parachute_name	 =  "pilot_raf_parachute",
			}, -- end of [4]
			[5] =
			{	pilot_name          = "pilot_raf", --engineer
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-7.4,	-0.3,	-1.6},
				drop_parachute_name	 =  "pilot_raf_parachute",
			}, -- end of [5]
	}, -- end of crew_members
	
	fires_pos = 
	{
		[1] = 	{-2.75, 0.25, 0.25},
		[2] = 	{-0.4, -0.75, 1.4},
		[3] = 	{-1.75, -0.75, -1.4},
		[4] = 	{1.4, -0.4, 2.8},
		[5] = 	{1.55, -0.4, -2.8},
		[6] = 	{3.45, -0.75, 2.4},
		[7] = 	{-2.1, -0.8, -3.5},
		[8] = 	{-10.3, 0.3, -0.25},
	}, -- end of fires_pos
	
	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,
	chaff_flare_dispenser 	= 
	{
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = 
	{
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = 
	{
	},
	HumanRadio = 
	{
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Guns = 
	{
	},

	Pylons = 
    {
    },
	
	

-----------------------------------------------------------------------------------	

-----------------------------------------------------------------------------------	

	Tasks = 
	{
		aircraft_task(Transport),
    },	
	DefaultTask = aircraft_task(Transport),

	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.2,  -- zero AoA lift coefficient
			Mzalfa		=	3.4,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.85,    
			kjz			=	0.00125, 
			Czbe		=	-0.012, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0305,    -- coefficient, drag, gear
			cx_flap		=	0.045,   -- coefficient, drag, full flaps
			cy_flap		=	0.37,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{
			--   M		Cx0		Cya		B		B4			Omxmax	Aldop	Cymax
				{0,		0.0249,	0.117,	0.042,	0.000089,	0.23,	20,		1.60}, --0
				{0.1,	0.0249,	0.117,	0.042,	0.000089,	0.26,	20,		1.60}, --76.7269mph
				{0.2,	0.0249,	0.116,	0.042,	0.000089,	0.26,	20,		1.60}, --153.454 mph
				{0.3,	0.0249,	0.1163,	0.040,	0.000089,	0.26,	18,		1.56}, --230.2 mph
				{0.4,	0.0249,	0.1176,	0.038,	0.000192,	0.22,	17,		1.24}, --306.908
				{0.5,	0.0249,	0.1179,	0.030,	0.000593,	0.18,	13,		1.0}, --383.635
				{0.6,	0.0249,	0.1183,	0.028,	0.0032,		0.1,	9,		0.9}, --460.361
				{0.7,	0.037,	0.1185,	0.149,	0.19,		0.1,	6,		0.8}, --537.088
				{0.8,	0.044,	0.1186,	0.17,	0.4,		0.1,	3,		0.6}, --613.815
				{0.9,	0.0995,	0.1185, 0.175,	2.7925,		0.1,	3,		0.4}, --690.542
				{1,		0.146,	0.1184,	0.2,	3.19,		0.1,	1,		0.2}, --767.269
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nominal_RPM = 2700.0,
			Nmg	=	25.926, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			type    = "Radial",
			cylinder_firing_order = {1, 10, 5, 14, 9, 4, 13, 8, 3, 12, 7, 2, 11, 6},
			--	E_TURBOJET = 0
			--	E_TURBOJET_AB = 1
			--	E_PISTON = 2
			--	E_TURBOPROP = 3
			--	E_TURBOFAN	= 4
			--	E_TURBOSHAFT = 5
			hMaxEng	=	12.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.015, -- Engine drag coeficient
			cemax	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	1800, --  altitude coefficient for max thrust 2100?
			dpdh_f	=	1800, --  altitude coefficient for AB thrust
			table_data = 
			{
				[1] = 	{0,		17395.9	,17395.9},
				[2] = 	{0.1,	17193.8	,17193.8},
				[3] = 	{0.2,	16995.6	,16995.6},
				[4] = 	{0.3,	16800.8	,16800.8},
				[5] = 	{0.4,	14773.3	,14773.3},
				[6] = 	{0.5,	12854.2	,12854.2},
				[7] = 	{0.6,	10029.2	,10029.2},
				[8] = 	{0.7,	8312.3	,8312.3},
				[9] = 	{0.8,	5719.3	,5719.3},
				[10] = 	{0.9,	3650	,3650},
			},			
--[[			{
			--   M		Pmax		 Pfor	
				{0,		608000,	608000},
				{0.1,	568000,	568000},
				{0.2,	520000,	520000},
				{0.3,	484000,	484000},
				{0.4,	440000,	440000},
				{0.5,	418000,	418000},
				{0.6,	410000,	410000},
				{0.7,	436000,	436000},
				{0.798,	470000,	470000},
				{0.9,	524000,	524000},
				{1,		560000,	560000},
			}, -- end of table_data
--]]			
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB

			k_adiab_1			= 0.037923, --adiabatic constant?
			k_adiab_2			= 0.0562, --adiabatic constant?
			MAX_Manifold_P_1	= 135456, --cont cruise manifold pressure in Pa?
			MAX_Manifold_P_2	= 162547, --takeoff manifold pressure in Pa?
			MAX_Manifold_P_3	= 162547, --emergency manifold pressure in Pa (same as t/o for DC3)
			k_after_cool		= 0.54, --something to do with turbocharging?
			Displ				= 29.98, --engine displacement litres
			k_Eps				= 6.7, --compression ratio?
			Stroke				= 0.139, --length of piston stroke in metres
			V_pist_0			= 14, --no# cylinders?
			Nu_0				= 1.2, 
			Nu_1				= 0.9,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220, 
			D_prop				= 3.51, --dia of propeller in metres
			MOI_prop			= 46, --momemt of inertia propeller
			k_gearbox			= 1.778, --gear reduction for prop
			P_oil				= 586054, -- oil pressure? 85psi at 140deg F
			k_boost				= 3, --type of boost ?? 
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,

		}, -- end of engine
	}, -- end of SFM_Data

	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	
----------------------------------------------------------------------------------------------------
---  Damage Section
-----------------------------------------------------------------------------------------------------	
Damage = {
	[0]  		= {critical_damage = 15,droppable=false}, --nose
	[1]			= {critical_damage = 15,droppable=false}, -- nose left
	[2]			= {critical_damage = 15,droppable=false}, -- nose right
	[3]			= {critical_damage = 10}, -- cockpit 
 	[4]			= {critical_damage = 15, args = {154},droppable=false},-- cabin left*
	[5]			= {critical_damage = 15, args = {153},droppable=false},-- cabin right*
	[6]			= {critical_damage = 15,droppable=false}, -- cabin bottom
	[9]		 	= {critical_damage = 15, args = {154},droppable=false}, -- fuselage left
	[10]		= {critical_damage = 15, args = {153},droppable=false}, -- fuselage right		
	[11]		= {critical_damage = 8, args = {431,167}},  -- Engine 1 count from left
	[12]		= {critical_damage = 8, args = {430,161}},  -- Engine 2 count from left
	[13]		= {critical_damage = 2},  -- Engine 1 nacelle bottom count from left
	[14]		= {critical_damage = 2},  -- Engine 2 nacelle bottom count from left
	[17]		= {critical_damage = 2},  -- Engine 1 nacelle count from left
	[18]		= {critical_damage = 2},  -- Engine 2 nacelle count from left	
	[23]		= {critical_damage = 20, args = {225}, deps_cells = {25}}, -- wing out left
	[24]		= {critical_damage = 20, args = {215}, deps_cells = {26}},-- wing out right
	[25]		= {critical_damage = 2}, -- eleron left 
	[26]		= {critical_damage = 2}, -- eleron right 
	
	[29]		= {critical_damage = 20, args = {225}, deps_cells = {23, 35, 37}}, -- wing center left 
 	[30]		= {critical_damage = 20, args = {215}, deps_cells = {24, 36, 38}},-- wing center right 
	[35]		= {critical_damage = 20, args = {225}}, -- wing in left* 
	[36]		= {critical_damage = 20, args = {215}}, -- wing in right* 	
	[37]		= {critical_damage = 2}, -- flap in left 
	[38]		= {critical_damage = 2},-- flap in right
 	
	[39]		= {critical_damage = 5,droppable=false}, -- fin top left
	[40]		= {critical_damage = 5,droppable=false}, --fin top right
	[41]		= {critical_damage = 5,droppable=false}, --fin centre left		
	[42] 		= {critical_damage = 5,droppable=false}, --fin centre right	
	[43]		= {critical_damage = 5, args = {243},droppable=false}, -- Vertical stabilizer* fin bottom left
	[44] 		= {critical_damage = 5,droppable=false}, --fin bottom right
	[45]		= {critical_damage = 5, args = {236},droppable=false}, -- stabilizer out left
	[46]		= {critical_damage = 5, args = {234},droppable=false}, -- stabilizer out right
	[47]		= {critical_damage = 5, args = {236},droppable=false}, -- stabilizer in left*
	[48]		= {critical_damage = 5, args = {234},droppable=false}, -- stabilizer in right*
	[49]		= {critical_damage = 2, args = {236},droppable=false},-- elevator out left
	[50]		= {critical_damage = 2, args = {234},droppable=false},-- elevator out right
	[53]		= {critical_damage = 5, args = {247}, deps_cells = {54},droppable=false}, -- rudder left*
	[54]		= {critical_damage = 5, args = {247}, deps_cells = {53},droppable=false}, -- rudder right*
	[55] 		= {critical_damage = 35,args = {81}, deps_cells = {39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}},--- coda *
	[56]		= {critical_damage = 20,args = {158},droppable=false}, -- - coda a sinistra *
	[57] 		= {critical_damage = 20,args = {157},droppable=false}, -- - coda destra *
	[58] 		= {critical_damage = 20,droppable=false}, --tail bottom
	[59]		= {critical_damage = 15,droppable=false}, -- nose bottom 	
	[82]		= {critical_damage = 20,droppable=false},-- fuselage bottom
	[61]		= {critical_damage = 6}, -- fuel tank left
	[62] 		= {critical_damage = 6}, -- fuel tank right
	},
	DamageParts = 
	{  
		[1] = "dc3-oblomok-wing_r.edm",
		[2] = "dc3-oblomok-wing_l.edm",
		[3] = "DC3-oblomok-tail.edm",
		
		
	},

	lights_data = {	typename = "collection", lights = {
    [1] = {typename = "collection",lights = {}},
	[2] = {typename = "collection",
			lights = {-- Landing light
					  {typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_02",
					   argument = 209,
					   dir_correction = {elevation = math.rad(-1)}
					  },
					  {-- Landing/Taxi light
					   typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_01",
					   argument = 208,
					   dir_correction = {elevation = math.rad(3)}
					  }
					 }
			},
    [3]	= {typename = "collection",
			lights = {-- Left Position Light (red)
					  {typename = "omnilight",
					   connector = "BANO_1",
					   color = {0.99, 0.11, 0.3},
					   pos_correction  = {0, 0, -0.2},
					   argument  = 190
					  },
					  -- Right Position Light (green)
					  {typename = "omnilight",
					   connector = "BANO_2",
					   color = {0, 0.894, 0.6},
					   pos_correction = {0, 0, 0.2},
					   argument  = 191
					   },
					  -- Tail Position Light (white)
					  {typename = "omnilight",
					  connector = "BANO_0",
					  color = {1, 1, 1},
					  pos_correction  = {0, 0, 0},
					  argument  = 192
					  }}
			},
    [4] = {typename = "collection",lights = {}},
	[5]	= {typename = "collection",lights = {}},
	}}, -- end lights_data

}

add_aircraft(DC3)
